{*************************************************************}
{                                                             }
{       Borland Delphi Visual Component Library               }
{       InterBase Express core components                     }
{                                                             }
{       Copyright (c) 1998-2002 Borland Software Corporation  }
{                                                             }
{    Additional code created by Jeff Overcash and used        }
{    with permission.                                         }
{*************************************************************}

unit IBVclReg;

interface

uses DesignIntf, DesignEditors, TreeIntf;

procedure Register;

type
  TIBFilterDialogSprig = class(TComponentSprig)
  public
    procedure FigureParent; override;
    function AnyProblems: Boolean; override;
    function DragDropTo(AItem: TSprig): Boolean; override;
    function DragOverTo(AItem: TSprig): Boolean; override;
    class function PaletteOverTo(AParent: TSprig; AClass: TClass): Boolean; override;
  end;

implementation

uses IBFilterDialog, frmIBFilterFieldEditorU, Classes,
     SysUtils, IBXConst, IBDBReg, IBCustomDataSet;

procedure Register;
begin
  RegisterComponents('InterBase', [TIBFilterDialog]); {do not localize}
  RegisterPropertyEditor(TypeInfo(TStringList), TIBFilterDialog, 'Fields', TIBFilterFieldEditor);  {do not localize}

  RegisterSprigType(TIBFilterDialog, TIBFilterDialogSprig);
end;

{ TIBFilterDialogSprig }

function TIBFilterDialogSprig.AnyProblems: Boolean;
begin
  Result := Not Assigned(TIBFilterDialog(Item).DataSet);
end;

function TIBFilterDialogSprig.DragDropTo(AItem: TSprig): Boolean;
var
  vDataSet : TIBCustomDataSet;

  function IBFilterDialogDropOver(AParent: TSprig; var ADataSet: TIBCustomDataSet): Boolean;
  var
    vParentDataSet : TIBCustomDataSet;
  begin
    Result := False;
    if AParent is TIBCustomDataSetSprig then
    begin
      vParentDataSet := TIBCustomDataSet(AParent.Item);
      Result := vParentDataSet <> ADataSet;
      if Result then
        ADataSet := vParentDataSet;
      if (vParentDataSet = nil) or
         (ADataSet <> vParentDataSet) then
      begin
        Result := True;
        ADataSet := vParentDataSet;
      end;
    end;
  end;

begin
  with Item as TIBFilterDialog do
  begin
    vDataSet := DataSet;
    Result := IBFilterDialogDropOver(AItem, vDataSet);
    if Result then
      DataSet := vDataSet;
  end;
end;

function TIBFilterDialogSprig.DragOverTo(AItem: TSprig): Boolean;
begin
  Result := AItem is TIBCustomDataSetSprig;
end;

procedure TIBFilterDialogSprig.FigureParent;
begin
  with Item as TIBFilterDialog do
  begin
    if DataSet <> nil then
      Self.SeekParent(DataSet).Add(Self)
    else
      Self.Root.Add(Self);
  end;
end;

class function TIBFilterDialogSprig.PaletteOverTo(AParent: TSprig;
  AClass: TClass): Boolean;
begin
  Result := AParent is TIBCustomDataSetSprig;
end;

end.
